clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

%% Costanti fisiche
T=293;          % Temperatura assoluta [K]
T0=273;         % Temperatura assoluta rif. [K]
mu=1.81e-5;     % viscosit` dinamica dell'aria a 0 C [Pas]
R=287.053;      % Costante dell'aria [J/Kg/K]
Pa=1e5;         % Pressione ambiente a 273 K [Pa]
Ps=3.62*1e5;    % inserire la p1min la P_fine_regolazione o Ps = 5, 6, 7 

Kt=sqrt(T/T0);
rho=Pa/(R*T);   % Densità dell'aria in condizioni normali [kg/m^3]
psi=0.6855/sqrt(R*T);
cost=1/(24*mu*R*T);
dt=1e-7;        % parametro per la soluzione statica
ck=60000/rho;   % per passare da l/min a kg/s

%% Geometria pattino
n_fori=4;
dp=1e-3;        % foro ingresso pattino
hg=30e-6;       % profondità media ragnatura
wg=0.2e-3;      % larghezza ragnatura
L=60e-3;
B=30e-3;
l=45e-3;
b=20e-3;
lx=(L-l)/2;
ly=(B-b)/2;
coeff=1;
A=L*B*coeff;            % Aumentando coeff gira più veloce (equivale ad aumentare il passo di tempo)
Vg=1*wg*hg*2*(l+b);     % volume ragnatura


d_con=5e-3;             % diametro condotti interni al pattino
V_cond=pi*d_con^2/4*(60+30)*1e-3;
V1=V_cond;         
S_eqv=(l*b+L*B+0.5*(L*b+B*l))/3;        % superficie equivalente su cui insiste la Fp considerando una distribuz. di pressione a tronco di piramide

%%Inizializzazione pressioni
p1=Ps; % [Pa]
p2=Ps;
p0=Ps;

%%inizializzazione Reynolds
Re2=0;

%%Punto iniziale simulazione
h0=5*1e-6;
V0=h0*l*b;      % volume meato
V2=V0+Vg;       % volume tot = volume meato + volume ragnatura

Fp0=0;
err_Fp=10;
errq=10;
tic
j=0;
while (abs(err_Fp)>1e-6 || abs(errq)>1e-6)
j=j+1;

%Conduttanza foro pattino (si una la sezione anulare)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+2*wg*hg)*psi;   %conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);             %portata attraverso un foro del pattino
g2=g2*Kt;
heq=(pi*h0*dp+2*hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

%Portate uscita meato
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);  

%Calcolo Pressioni
p0=p0+(g2*n_fori-g3)*dt*R*T/V2;
af=0.14;bf=5e-6;
f=1-af^(bf/h0);        % f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;   % formula inversa per trovare p2

%Calcolo Forza
Fp=S_eqv*(p0-Pa);

% calcolo gli errori per uscire dal while
err_Fp=(Fp-Fp0)/Fp;
errq=(n_fori*g2-g3)/(n_fori*g2);

Fp0=Fp;
end
    toc
    
%% Modello con forza in ingresso a gradino
i=0;
F_EXT=[Fp:-5:30];
for i=1:length(F_EXT)

    g=9.806;
    h0_dot=0;           % condizione iniziale di velocità --> serve per Eulero esplicito in avanti
    err_Fp=10;
    errq=10;
    F_ext=F_EXT(i);
    M=F_ext/g;          % massa supportata dal pattino
    
    tic
    j=0;
while (abs(err_Fp)>1e-6 || abs(errq)>1e-6)
j=j+1;

%Conduttanza foro pattino (si una la sezione anulare)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+2*wg*hg)*psi;   %conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);             %portata attraverso un foro del pattino
g2=g2*Kt;
portata1=g2;
heq=(pi*h0*dp+2*hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

%Portate uscita meato
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);

%Calcolo forza e nuovo meato di equilibrio
Fp=S_eqv*(p0-Pa);
h1_dot=h0_dot+dt/M*(Fp-F_ext);       % Eulero esplicito in avanti
h1=h0+h1_dot*dt;                     % Eulero esplicito in avanti

%Calcolo Pressioni
V2=h0*l*b+Vg;
p0=p0+((g2*n_fori-g3)-(h1-h0)/dt*A*p0/(R*T))*dt*R*T/V2;
af=0.14;bf=5e-6;
f=1-af^(bf/h0);    %f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;

% calcolo gli errori per uscire dal while
err_Fp=(Fp-F_ext)/F_ext;
errq=(n_fori*g2-g3)/(n_fori*g2);

Fp0=Fp;  
h0=h1;
h0_dot=h1_dot;

% %Reynolds Conduttanze 
%    RRe1(j)=Re1;
%    RRe2(j)=Re2;
%    Cda1(j)=cda1;
%    Cda2(j)=cda2;
%    Cs1(j)=C1;
%    Cs2(j)=C2;
% 
%    %Pressioni
%    P1(j)=p1;
%    P2(j)=p2;
%    P0(j)=p0;
% 
% %Caratteristiche pattino + valvola 
%    H0(j)=h_new*1e6;
%    Xv(j)=x;
%    G1(j)=g1*ck;
%    G2(j)=g2*n_fori*ck;
%    G3(j)=g3*ck;
%    Fm(j)=Fp;

end

%     figure
%     plot(G1,'linewidth',2),grid on, hold on,
%     xlabel('Iterations '),ylabel('Force [N]')
%     grid on, zoom on
%     set(gca,'FontSize',32)

toc

   %Reynolds Conduttanze 
   RRe2(i)=Re2;
   Cda2(i)=cda2;
   Cs2(i)=C2;

   %Pressioni
   P2(i)=p2;
   P0(i)=p0;

%Caratteristiche pattino + valvola 
   H0(i)=h0*1e6;
   H_dot(i)=h0_dot;
   G2(i)=g2*n_fori*ck;
   G3(i)=g3*ck;
   Fm(i)=Fp;
end

% Calcolo il deltaF relativo al +/- 5% di h_des
ind_1=H0>=h_des*0.95;    % prendo il 5% a sinistra di h_des
ind_1=find(ind_1,1,'first');   % trovo il primo 1
ind_2=H0>=h_des*1.05;
ind_2=find(ind_2,1,'first');
F_1_ris=Fm(ind_1);
F_2_ris=Fm(ind_2);
campo_ris=F_1_ris-F_2_ris;     % Newton (N)

%%
%     figure
%     plot(H0,'linewidth',2),grid on, hold on,
% 	  xlabel('Iterations '),ylabel('Gap [\mum]')
%     grid on, zoom on
%     set(gca,'FontSize',32)
%     
%     figure
%     plot(Fext,'linewidth',2),grid on, hold on,
%     plot(Fp,'linewidth',2),grid on, hold on,
%     plot(Fm,'linewidth',2),grid on, hold on,
%     xlabel('Iterations '),ylabel('Force [N]')
%     grid on, zoom on
%     set(gca,'FontSize',32)
%%

x_min=min(H0);
x_max=max(H0);

F_min=min(Fm);
F_max=max(Fm);

figure % capacità di carico
plot(H0,Fm,'b','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Force  $ \quad F$ $(N)$ '),
titleText = ['Load capacity'];
title(titleText,'Interpreter','Latex','FontSize',32,'FontName','Times New Roman' );
set(gca,'TickLabelInterpreter','latex','FontSize',32,'FontName','Times New Roman');
grid on, zoom on
xlim([x_min x_max])

figure % consumo d'aria
plot(H0,G3,'b','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Air \quad Mass \quad Flow \quad Rate  \quad $Q$ $(\frac{l}{min} \quad ANR \quad 20^{\circ}$)'),
titleText = ['Air consumption'];
title(titleText,'Interpreter','Latex','FontSize',32,'FontName','Times New Roman' );
set(gca,'TickLabelInterpreter','latex','FontSize',32,'FontName','Times New Roman');
grid on, zoom on
xlim([x_min x_max])

%% calcolo della rigidezza statica Ks

Ks=zeros(size(Fm));
Hk=zeros(size(Fm));

Ks(1:end-1)=-diff(Fm)./diff(H0);
Ks(end)=-(Fm(end)-Fm(end-1))/(H0(end)-H0(end-1));
Hk(1:end-1)=H0(1:end-1)+diff(H0)/2;
Hk(end)=H0(end-1)+(H0(end)-H0(end-1))/2;

figure   % rigidezza statica
plot(Hk,Ks,'b','linewidth',2),grid on, hold on,
xlabel('Air gap $ \quad h$ ($\mu m$)'),
ylabel('Stiffness $\quad k_s$ ($\frac{N}{\mu m}$)'),
titleText = ['Static stiffness'];
title(titleText,'Interpreter','Latex','FontSize',32,'FontName','Times New Roman' );
set(gca,'TickLabelInterpreter','latex','FontSize',32,'FontName','Times New Roman');
grid on, zoom on,
xlim([x_min x_max])

%% Salvataggio 
        
stringa_H0_nv=['H0_nv_' num2str(round(abs(Ps*1e-3))) '=H0;'];
stringa_Fm_nv=['Fm_nv_' num2str(round(abs(Ps*1e-3))) '=Fm;'];
stringa_G2_nv=['G2_nv_' num2str(round(abs(Ps*1e-3))) '=G2;'];
stringa_Hk_nv=['Hk_nv_' num2str(round(abs(Ps*1e-3))) '=Hk;'];
stringa_Ks_nv=['Ks_nv_' num2str(round(abs(Ps*1e-3))) '=Ks;'];
stringa_Ps_nv=['Ps_nv_' num2str(round(abs(Ps*1e-3))) '=Ps;'];
stringa_campo_ris_nv=['campo_ris_nv' '=campo_ris;'];
stringa_ind1_nv=['ind_1_nv' '=ind_1;' ];
stringa_ind2_nv=['ind_2_nv' '=ind_2;' ];

structure_static=['save Simul_Stat_NV_Ps' num2str(round(abs(Ps*1e-3))) ' H0_nv_' num2str(round(abs(Ps*1e-3))) ' Fm_nv_' num2str(round(abs(Ps*1e-3))) ' G2_nv_' num2str(round(abs(Ps*1e-3))) ' Hk_nv_' num2str(round(abs(Ps*1e-3))) ' Ks_nv_' num2str(round(abs(Ps*1e-3))) ' Ps_nv_' num2str(round(abs(Ps*1e-3))) ' campo_ris_nv' ' ind_1_nv' ' ind_2_nv'];

eval(stringa_H0_nv)
eval(stringa_Fm_nv)
eval(stringa_G2_nv)
eval(stringa_Hk_nv)
eval(stringa_Ks_nv)
eval(stringa_Ps_nv)
eval(stringa_campo_ris_nv)
eval(stringa_ind1_nv)
eval(stringa_ind2_nv)

eval(structure_static) 


